document.addEventListener("DOMContentLoaded", function() {
    fetchWebsiteData();
});

function fetchWebsiteData() {
    chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
        document.getElementById("current-url").innerText = tabs[0].url;
        const domain = new URL(tabs[0].url).hostname;

        // DNS-Abfrage zur Ermittlung der Server-IP
        fetch(`https://dns.google/resolve?name=${domain}&type=A`)
            .then(response => response.json())
            .then(data => {
                if (data.Answer && data.Answer.length > 0) {
                    const serverIP = data.Answer[0].data;
                    document.getElementById("server-ip").innerText = serverIP;

                    // Jetzt WHOIS-Abfrage für den Server-IP-Anbieter
                    return fetch(`https://ipwhois.app/json/${serverIP}`);
                } else {
                    throw new Error("Keine IP gefunden.");
                }
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById("hoster").innerText = data.isp || "Nicht verfügbar";
                document.getElementById("server-location").innerText = `${data.city || 'Unbekannt'}, ${data.country || 'Unbekannt'}`;
            })
            .catch(error => {
                console.error("Fehler beim Abrufen der Server-Daten:", error);
                document.getElementById("server-ip").innerText = "Fehler beim Laden";
                document.getElementById("hoster").innerText = "Fehler beim Laden";
                document.getElementById("server-location").innerText = "Fehler beim Laden";
            });

        // SSL-Zertifikat abrufen (Direkt über Chrome API)
        fetch(`https://api.ssllabs.com/api/v3/analyze?host=${domain}`)
            .then(response => response.json())
            .then(data => {
                if (data.endpoints && data.endpoints.length > 0) {
                    document.getElementById("ssl-cert").innerText = `✅ Sicher (${data.endpoints[0].grade || 'N/A'})`;
                } else {
                    document.getElementById("ssl-cert").innerText = "❌ Kein SSL-Zertifikat gefunden";
                }
            })
            .catch(error => {
                console.error("Fehler beim Abrufen des SSL-Zertifikats:", error);
                document.getElementById("ssl-cert").innerText = "Fehler beim Laden";
            });
    });
}